//
//  GeometryGamesiOSonMacMessage.swift
//  Crystal Flight
//
//  Created by Jeff on 1/15/21.
//  Copyright © 2020 Jeff Weeks. All rights reserved.
//

import SwiftUI


struct GeometryGamesiOSonMacMessage: View {

	let menuImage: Image
	
	let theFrameWidth: CGFloat = 384.0

	var body: some View {

		let theTitleString = Bundle.main.localizedString(
			forKey: "MultiTouchMessage-Title",
			value: nil,
			table: "GeometryGamesLocalizable")

		let theFirstString = Bundle.main.localizedString(
			forKey: "MultiTouchMessage-First",
    		value: nil,
			table: "GeometryGamesLocalizable")

		let theThenString = Bundle.main.localizedString(
			forKey: "MultiTouchMessage-Then",
			value: nil,
			table: "GeometryGamesLocalizable")

		VStack() {
		
			Text(theTitleString)
				.font(.title)
				.padding(8.0)
			
			Text(theFirstString)
				.padding(8.0)
				.frame(width: theFrameWidth, alignment: .leading)
			
			//  The menuImage depends not only on the user's language,
			//  but also on which Geometry Games app the user is running
			//  (because the menu title is the app name).
			//  To create these images, first to to
			//
			//		System Preferences > Desktop & Screen Saver > Desktop
			//			> Apple > Colors > Custom Color…
			//
			//  and set the desktop color to pure white.
			//  Then go to
			//
			//		System Preferences > Accessibility > Display > Display
			//
			//  and enable "Reduce transparency".
			//  Take a screenshot that's 256pt high ( = 512px on a 2x display)
			//  and as wide as it needs to be to approximately match
			//  the margins of the existing screenshots (cf. Crystal Flight's
			//  en and pt images), and then restore your original
			//  Desktop and Display settings.
			//
			menuImage
			
			Text(theThenString)
				.frame(width: theFrameWidth, alignment: .leading)
		}
		.padding(2 * geometryGamesPanelPadding)
		.background(Color.white)
		.cornerRadius(geometryGamesCornerRadius)
		.onDisappear() {
			print("bye")
		}
	}
}
